/**
    _______. _______ .__   __.  _______   _______ .______      
    /       ||   ____||  \ |  | |       \ |   ____||   _  \     
   |   (----`|  |__   |   \|  | |  .--.  ||  |__   |  |_)  |    
    \   \    |   __|  |  . `  | |  |  |  ||   __|  |      /     
.----)   |   |  |____ |  |\   | |  '--'  ||  |____ |  |\  \----.
|_______/    |_______||__| \__| |_______/ |_______|| _| `._____|
                                                        
The program transforms your laptop into a small radio transmitter. 
You'll be prompted to enter a word and the program will convert 
the ascii characters to binary. This binary will be used to generate
a BFSK modulated signal, which is then written to a wav file. 
**/

#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "tinywav.h"

#define NUM_CHANNELS 1
#define SAMPLE_RATE 48000
#define BLOCK_SIZE 512

#define ZERO_FREQUENCY 1400
#define ONE_FREQUENCY 2400
#define PI 3.14159265
#define AMPLITUDE 3
#define BAUD_RATE 120
#define SAMPLES_PER_SECOND 48000 //48 KHz
#define MIN(x, y) (((x) < (y)) ? (x) : (y))

/***
    generate a pulse who length and frequency depend
    on the baud rate and the value (0 or 1) it is passed.  
*/
float * generate_pulse( bool is_a_one){
   //TODO: Implement this function 
}

/**
Takes and array of char and converts to an array of 
binary values presentting the ascii encoding. 
Credit to @gowrath on stack overflow. 
**/
char* text_to_binary(char * text){
    int text_length = strlen(text);
    char* binary = malloc(text_length * 8 + 1);
    binary[0] = '\0';
    for(size_t i = 0; i < text_length; ++i) {
        char ch = text[i];
        for(int j = 7; j >= 0; --j){
            if(ch & (1 << j)) {
                strcat(binary,"1");
            } else {
                strcat(binary,"0");
            }
        }
    }
    return binary;
}

/**
* Converts the binary samples to audio samples
* which can then the played through speaker. 
* @param binary pointer to the array of chars 
**/
float * binary_to_audio_samples(char* binary){
    //TODO: Implement this function
}

/**
 * Write the samples to to wave file
 * @param samples pointer to samples array.  
 * @param outputhPath the path specifing were to write the wave file. 
 * @param length the number of samples in the wave file. 
 **/
void write_wav_file(float* samples, char* outputPath, int length){
    //TODO: Implement this funciton
}

int main(int argc, char *argv[]){   
    //Print Text 
    printf("%s\n", argv[1]);
    //Read text form command line and convert to binary
    char* binary = text_to_binary(argv[1]);
    //Print binary
     printf("%s\n", binary);
    //Name of output file
    char *outputPath = argv[2];
    //Convert binary to audio samples 
    float* audio_samples = binary_to_audio_samples(binary);
    //Save audio to file.
    //TODO: Call the function save audio file.
}
